from Range import NSIRange
from Range.arrayController import muriTileV2
from Range.Mappings import *
from Optimizer import *
from Storage import *
import sqlite3
import time
import random
import math

# BATCH loop
# OPTIMIZER provides initial states
# for each beam position
    # move to beam position
    # for each state
        # optimize phase
        # store phase settings
# for each measurement position
    # for each state    (state loop outside of beam loopbecause states are slower to reprogram)
        # for each beam position
            # assign phases
            # measure value
        # store data (somewhere in the loop, probably between states, though maybe between measurement positions).
# OPTIMIZER looks at data and determines the next states

def optimizeMetaGaps(verbose):

    #evaluation = 'MBP'
    #evaluation = 'SLL'
    evaluation = 'FOV'

    #algorithm = 'Random'
    #algorithm = 'Genetic'
    #algorithm = 'VNS'
    algorithm = 'PS'
    #algorithm = 'SA'

    #mapping = 'Independent'
    #mapping = 'E Plane Symmetry'
    #mapping = 'E and H Planes Symmetry'
    #mapping = 'Symmetric Identical Edge'
    mapping = 'Symmetric Interior E and H'
    #mapping = 'Symmetric Interior vs Edge'
    #mapping = 'Identical'

    # RANDOMIZE INITIAL STATES
    initial_states = [None]

    # BEST STATES FOUND FOR IDENTICAL MBP MAPPED TO Independent
    #initial_states = [912995907729282610642717565647457875697622004315860010771188512690812947498593555905304564000180579034493309077452273342868300122958928521384898219671589572069294563391384386787820818167066374462183190490027086165349674773171164470487205557595600500249465397379627892952582706277046025160, 908237453338527721200920765134293232898283851325782795830562080371891810964624207438863720354813607934488111678851391145807649858923107096528057148496701889172413273682809785636157594630992328830217090379264855547232589642045120319800959109020081752572912117453547775265249359246015323080, 300354198775822538154820508953512389975802264173477331725966262630339511594832849734769461931927907274253841658757832819350712710893865034787033823621938851601486484681366548279055130131001893966922735018668726564450974072589710624614784378592435796947286375021668365938272348975263114200, 479981205098703643010929223637476518304333810883862823454398627169300969329779299901049550908158637616735194630356564584369693136972651341272572501615379654705926185545576711870404647501062669263455547305303516157532932806649512035529683274770831491710144808168764996020177162924962126800, 904079033540747660957534132459275449963657162207623276572756339530686193722597038777822460631036490490037768883858261794152718799324419891871059439934565546172074754026598168247881591543253792126207653038817247027322895739001742625127761071257369507136334367088458961480627846624537198545]

    # BEST STATES FOUND FOR IDENTICAL MBP MAPPED TO E Plane Symmetry
    #initial_states = [746533686894537129659474709622879476910576486641492801937511190837468980914648561246016336102742834321721406273030588480899339564151902147643440072, 346925482304884218149967361955551636109633327791322706328454539546754776905705101217997546515566262465751608626275647105370699586517532444401851336, 447608018226886611176968740564592119088258420505393655354043242787253948701138507813579478841733464681536764098110885067117310379252837684798284760, 347315724692178800583979991504770663907597111973761753679482361652461802614419551084344447409979164984281160025700928052566594181053000475466308560, 796923735153950149373902890120930687665313776446999247818375301896302737463936359545244154830418170768069340220221130233910063763259289177830178769]

    # BEST STATES FOUND FOR IDENTICAL MBP MAPPED TO E and H Planes Symmetry
    #initial_states = [422523091967576536962573133184956405322459953867496636381789776739785243592, 196352864183249761645271192313718787973521163512535013202366486815656369096, 253337159843130680883202109321243260287388078340775863998925933641644631000, 196573733415083394957762245926083014692525330470845879515414112241797864400, 451042848454838836107975683349244157816988093544523210537065541333646032849]

    # BEST STATES FOUND FOR IDENTICAL MBP MAPPED TO Symmetric Identical Edge
    #initial_states = [1501103568442291223173061827313846113875896839813238999219144, 697585506455488376947724277647888825887609568754523839126472, 900034393123159336209944958260263306781425563730095490196440, 698370191596649885062796577720984511090752741576344957918160, 1602426097430647317693710659189478057189817027763905381253073]

    # BEST STATES FOUND FOR IDENTICAL MBP MAPPED TO Symmetric Interior E and H
    #initial_states = [19866046285390098371723478599183367112, 9232222319072085759959510836697357256, 11911437985754541617272899180444509144, 9242505814172118424839902002491988944, 21206942133367834387160894734777958353]

    # BEST STATES FOUND FOR IDENTICAL MBP MAPPED TO Symmetric Symmetric Interior vs Edge
    #initial_states = [70578374381789282565064, 32799442518694681893832, 42317928666174046331864, 32835976832402445867984, 75342193402746582319057]

    # BEST STATES FOUND FOR IDENTICAL MBP MAPPED TO Identical
    #initial_states = [2066813, 2066797, 2067740, 1901926, 10323453]

    extra_name = '' # added to the end of the experiment name
    #extra_name = ' Initialized' # added to the end of the experiment name

    warm_up_delay = 30# minutes

    num_top_states = 10

    num_batches = 30
    states_per_batch = 24
    num_repeats = 1

    ########################################################
    theta_m_vals = range(-90,91,5)
    phi_m_vals = [0, 90]
    phi_b_vals = [0, 90]

    experiment_name = algorithm + ' Optimization'

    if evaluation == 'MBP':
        theta_b_vals = range(-30,31,5)# only maximize beam / minimize psl within desired steering range
        experiment_name = experiment_name + ' Main Beam Power'
    elif evaluation == 'SLL':
        theta_b_vals = range(-30,31,5)# only maximize beam / minimize psl within desired steering range
        experiment_name = experiment_name + ' Side Lobe Level'
    elif evaluation == 'FOV':
        theta_b_vals = range(-90,91,5)
        experiment_name = experiment_name + ' Field of View'
    else:
        print "ERROR: SELECT AN EVALUATOR"

    if mapping == 'Identical':
        mapper = None
        experiment_name = experiment_name + ' Identical'
    elif mapping == 'Independent':
        mapper = IndependentSwitches.IndependentSwitches()
        experiment_name = experiment_name + ' Independent'
    elif mapping == 'E Plane Symmetry':
        mapper = EPlaneMirror.EPlaneMirror()
        experiment_name = experiment_name + ' E Symmetric'
    elif mapping == 'E and H Planes Symmetry':
        mapper = EandHPlaneMirror.EandHPlaneMirror()
        experiment_name = experiment_name + ' EH Symmetric'
    elif mapping == 'Symmetric Identical Edge':
        mapper = SymmetricIdenticalEdges.SymmetricIdenticalEdges()
        experiment_name = experiment_name + ' Symmetric Identical Edges'
    elif mapping == 'Symmetric Interior E and H':
        mapper = SymmetricInteriorEandH.SymmetricInteriorEandH()
        experiment_name = experiment_name + ' Symmetric Interior EH'
    elif mapping == 'Symmetric Interior vs Edge':
        mapper = SymmetricInteriorVsEdge.SymmetricInteriorVsEdge()
        experiment_name = experiment_name + ' Symmetric Interior vs Edge'
    else:
        print "ERROR: SELECT A MAPPING"

    if mapper is None:
        num_bits = 24
    else:
        num_bits = mapper.num_bits
    maximum_state = 2**num_bits-1

    experiment_name = experiment_name + extra_name

    print 'RUNNING EXPERIMENT: ' + experiment_name

    tile_loc = { 1:(-2, 2), 2:(-1, 2), 3:( 0, 2), 4:( 1, 2), 5:( 2, 2), \
                 7:(-2, 1), 6:(-1, 1), 8:( 0, 1), 9:( 1, 1),10:( 2, 1), \
                11:(-2, 0),12:(-1, 0),13:( 0, 0),14:( 1, 0),15:( 2, 0), \
                16:(-2,-1),17:(-1,-1),18:( 0,-1),19:( 1,-1),20:( 2,-1), \
                21:(-2,-2),22:(-1,-2),23:( 0,-2),24:( 1,-2),25:( 2,-2)}
    addressList = [13,1,2,3,4,5,6,7,8,9,10,11,12,14,15,16,17,18,19,20,21,22,23,24,25]
    coordinateList = [tile_loc[addr] for addr in addressList]

    measurementRange = NSIRange.NSIRange(addressList,coordinateList, state_mapper = mapper)
    #measurementRange = SimulatedRange.SimulatedRange()
    #measurementRange = Range.EmptyRange()

    for i in range(num_repeats):
        n = 0
        with ExpandedExperimentDatabase.ExpandedExperimentDatabase(experiment_name,theta_b_vals,phi_b_vals,theta_m_vals,phi_m_vals,num_bits) as storage:
            if evaluation == 'MBP':
                evaluator = Evaluator.MaximizeMainLobe(storage,theta_b_vals, phi_b_vals,theta_m_vals,phi_m_vals)
            elif evaluation == 'SLL':
                evaluator = Evaluator.MinimizePeakSideLobeRelative(storage,theta_b_vals,phi_b_vals,theta_m_vals,phi_m_vals,30)
            elif evaluation == 'FOV':
                evaluator = Evaluator.MaximizeFieldOfView(storage,theta_b_vals, phi_b_vals,theta_m_vals,phi_m_vals,30)
            else:
                print "ERROR: SELECT AN EVALUATOR"

            if algorithm == 'Random':
                optimizer = RandomOptimizer.RandomOptimizer(num_batches, states_per_batch, num_bits, num_top_states, evaluator, use_tabu = False, verbose=verbose)
            elif algorithm == 'Genetic':
                optimizer = GeneticAlgorithm.GeneticAlgorithm(0.01, num_batches, states_per_batch, num_bits, num_top_states, evaluator, initial_population=initial_states, verbose=verbose)
            elif algorithm =='VNS':
                optimizer = VariableNeighborSearch.VariableNeighborSearch(3, states_per_batch, num_batches, num_bits, num_top_states, evaluator, initial_state=initial_states[0], verbose=verbose)
            elif algorithm == 'PS':
                optimizer = ParticleSwarm.ParticleSwarm( 0.5, 0.25, False, num_batches, states_per_batch, num_bits, num_top_states, evaluator, initial_states=initial_states, verbose=verbose)
            elif algorithm == 'SA':
                optimizer = SimulatedAnnealing.SimulatedAnnealing(SimulatedAnnealing.SimulatedAnnealing.linearCooling, num_batches, states_per_batch, num_bits, num_top_states, evaluator, initial_state=initial_states[0], verbose=verbose)
            else:
                print "ERROR: SELECT AN ALGORITHM"

            start_time = time.time()
            current_time = 0
            prev_min = -1
            print "\n----------- WARMING UP... -----------"
            while current_time < (warm_up_delay * 60):
                state = random.randint(0, maximum_state)
                measurementRange.programState(state)
                random_phases = [360*random.random() for time_num in range(len(addressList))]
                measurementRange.programPhases(random_phases)
                measurement = measurementRange.measure()
                current_time = time.time() - start_time
                current_min = math.floor(current_time/60.0)
                if current_min > prev_min:
                    prev_min = current_min
                    min_left = warm_up_delay - current_min
                    print min_left, "minutes remaining..."
                time.sleep(0.5)


            print "\n----------- OPTIMIZATION STARTED ----------- "
            while not optimizer.isFinished():
                print "\nMeasuring Batch " + str(n+1)+": Optimization {:.2f}".format(n*100.0/num_batches)+"% complete"
                n = n+1
                batch_states = optimizer.getNextStates()
                batch_states_actual = batch_states + [0]
                baseline_state = -1*(maximum_state+n)
                batch_states = batch_states + [baseline_state]
                storage.addBatchOfStates(batch_states)
                print "Optimizing Phases..."
                for phi_b in phi_b_vals:
                    measurementRange.moveToPhi(phi_b)
                    for theta_b in theta_b_vals:
                        measurementRange.moveToTheta(theta_b)
                        for state_idx in range(len(batch_states)):
                            measurementRange.programState(batch_states_actual[state_idx])
                            optimumPhaseSettings = measurementRange.optimizePhase()
                            storage.enterBeamPhaseSettings(batch_states[state_idx],theta_b,phi_b,optimumPhaseSettings)
                    theta_b_vals.reverse() # go in reverse sweep order to save time
                print "Measuring Patterns..."
                theta_m_indexes = range(len(theta_m_vals))
                for phi_m_idx in range(len(phi_m_vals)):
                    phi_m = phi_m_vals[phi_m_idx]
                    measurementRange.moveToPhi(phi_m)
                    for theta_m_idx in theta_m_indexes:
                        theta_m = theta_m_vals[theta_m_idx]
                        measurementRange.moveToTheta(theta_m)
                        for state_idx in range(len(batch_states)):
                            measurementRange.programState(batch_states_actual[state_idx])
                            for phi_b in phi_b_vals:
                                for theta_b in theta_b_vals:
                                    # pointer to DB, DO NOT MODIFY OPT_PHASE_SETTINGS
                                    opt_phase_settings = storage.getBeamPhaseSettings(batch_states[state_idx],theta_b,phi_b)
                                    measurementRange.programPhases(opt_phase_settings)
                                    measurement = measurementRange.measure()
                                    #temp = measurementRange.measureTemp()
                                    #supply = measurementRange.measureSupply() MUST TURN ON DEBUG TO USE
                                    #storage.addDebugData(temp, supply)
                                    storage.enterPatternData(batch_states[state_idx],theta_b,phi_b,theta_m_idx,phi_m_idx,measurement)
                    theta_m_indexes.reverse() # go in reverse sweep order to save time
                optimizer.evaluateMeasurements(batch_states,baseline_state)
            print "\n----------- OPTIMIZATION COMPLETE-----------"
            print

            print "\n----------- REMEASURING TOP STATES AND BASELINES ----------- "
            best_states = optimizer.getOptimalList()
            final_states = [-1*best_state for best_state in best_states]
            final_states_actual = best_states + [maximum_state,0]
            baseline_state = -1*(maximum_state+n+1)
            final_states = final_states + [-1*maximum_state,baseline_state]

            storage.addBatchOfStates(final_states)
            print "Optimizing Phases..."
            for phi_b in phi_b_vals:
                measurementRange.moveToPhi(phi_b)
                for theta_b in theta_b_vals:
                    measurementRange.moveToTheta(theta_b)
                    print "Optimizing Beams @ Phi = "+ str(phi_b) +", Theta = " + str(theta_b) + "..."
                    for state_idx in range(len(final_states)):
                        measurementRange.programState(final_states_actual[state_idx])
                        optimumPhaseSettings = measurementRange.optimizePhase()
                        storage.enterBeamPhaseSettings(final_states[state_idx],theta_b,phi_b,optimumPhaseSettings)
                theta_b_vals.reverse() # go in reverse sweep order to save time
            print "Measuring Patterns..."
            theta_m_indexes = range(len(theta_m_vals))
            for phi_m_idx in range(len(phi_m_vals)):
                phi_m = phi_m_vals[phi_m_idx]
                measurementRange.moveToPhi(phi_m)
                for theta_m_idx in theta_m_indexes:
                    theta_m = theta_m_vals[theta_m_idx]
                    measurementRange.moveToTheta(theta_m)
                    print "Measuring Patterns @ Phi = "+ str(phi_m) +", Theta = " + str(theta_m) + "..."
                    for state_idx in range(len(final_states)):
                        measurementRange.programState(final_states_actual[state_idx])
                        for phi_b in phi_b_vals:
                            for theta_b in theta_b_vals:
                                # pointer to DB, DO NOT MODIFY OPT_PHASE_SETTINGS
                                opt_phase_settings = storage.getBeamPhaseSettings(final_states[state_idx],theta_b,phi_b)
                                measurementRange.programPhases(opt_phase_settings)
                                measurement = measurementRange.measure()
                                #temp = measurementRange.measureTemp()
                                #supply = measurementRange.measureSupply() MUST TURN ON DEBUG TO USE
                                #storage.addDebugData(temp, supply)
                                storage.enterPatternData(final_states[state_idx],theta_b,phi_b,theta_m_idx,phi_m_idx,measurement)
                theta_m_indexes.reverse() # go in reverse sweep order to save time
            optimizer.evaluateMeasurements(final_states,baseline_state)
            print "\n----------- REMEASUREMENT COMPLETE-----------"
            print

            optimizer.getOptimalState()
        print "Completed Repetition:", str(i+1), "out of", str(num_repeats)
    print "\n----------- EXITING PROGRAM-----------"


if __name__ == '__main__':
    import cProfile
    #optimizeMetaGaps(True)
    cProfile.run('optimizeMetaGaps(True)')
